<?php
namespace App\Controllers;

use App\Config;
use App\Database;
use App\View;

class AdminJobsController
{
    private function check(): bool
    {
        $token = $_GET['token'] ?? $_POST['token'] ?? '';
        $expected = Config::get('app.admin_token','');
        return $expected && hash_equals($expected, $token);
    }

    public function index(): void
    {
        if (!$this->check()) { http_response_code(403); echo 'Forbidden'; return; }
        $pdo = Database::pdo();
        $jobs = $pdo->query('SELECT * FROM jobs ORDER BY id DESC LIMIT 200')->fetchAll();
        echo View::render('admin/jobs', [
            'title'=>'Jobs — BlocFolio', 'jobs'=>$jobs, 'token'=>($_GET['token']??'')
        ]);
    }

    public function enqueue(): void
    {
        if (!$this->check()) { http_response_code(403); echo 'Forbidden'; return; }
        $type = $_POST['type'] ?? '';
        Database::pdo()->prepare('INSERT INTO jobs (type, payload_json, status) VALUES (:t, :p, \"queued\")')
            ->execute([':t'=>$type, ':p'=>json_encode([])]);
        header('Location: /admin/jobs?token=' . urlencode($_GET['token'] ?? ''));
    }
}

