<?php
namespace App\Controllers;

use App\View;
use App\Config;
use App\Database;

class AdminSettingsController
{
    private function checkAuth(): bool
    {
        $token = $_GET['token'] ?? $_POST['token'] ?? '';
        $expected = Config::get('app.admin_token', '');
        return $expected !== '' && hash_equals($expected, $token);
    }

    public function index(): void
    {
        if (!$this->checkAuth()) { http_response_code(403); echo 'Forbidden'; return; }
        if (session_status() !== PHP_SESSION_ACTIVE) session_start();
        if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(16)); }

        $pdo = Database::pdo();
        $rows = [];
        try { $rows = $pdo->query('SELECT `key`, `value_json` FROM admin_settings')->fetchAll(); } catch (\Throwable $e) { $rows = []; }
        $settings = [];
        foreach ($rows as $r) { $settings[$r['key']] = json_decode($r['value_json'], true); }

        echo View::render('admin/settings', [
            'title' => 'Admin Settings — BlocFolio',
            'settings' => $settings,
            'csrf' => $_SESSION['csrf'],
            'token' => $_GET['token'] ?? '',
        ]);
    }

    public function save(): void
    {
        if (!$this->checkAuth()) { http_response_code(403); echo 'Forbidden'; return; }
        if (session_status() !== PHP_SESSION_ACTIVE) session_start();
        $csrf = $_POST['csrf'] ?? '';
        if (!hash_equals($_SESSION['csrf'] ?? '', $csrf)) { http_response_code(400); echo 'Bad CSRF'; return; }

        $pdo = Database::pdo();
        $upsert = $pdo->prepare('REPLACE INTO admin_settings (`key`, `value_json`) VALUES (:k, :v)');

        $pairs = [
            'app.base_url' => trim($_POST['app_base_url'] ?? ''),
            'app.currency_default' => strtoupper(trim($_POST['currency_default'] ?? 'USD')),
            'coingecko.rate_limit_per_min' => (int)($_POST['cg_rate'] ?? 30),
            'seo.coin.title' => trim($_POST['seo_coin_title'] ?? ''),
            'seo.coin.description' => trim($_POST['seo_coin_desc'] ?? ''),
            'seo.ga4_id' => trim($_POST['seo_ga4_id'] ?? ''),
        ];
        foreach ($pairs as $k => $v) {
            $upsert->execute([':k' => $k, ':v' => json_encode($v)]);
        }

        // Lists SEO
        $pairs2 = [
            'seo.lists.coins.title' => trim($_POST['seo_lists_coins_title'] ?? ''),
            'seo.lists.coins.description' => trim($_POST['seo_lists_coins_desc'] ?? ''),
            'seo.lists.coins.jsonld' => isset($_POST['seo_lists_coins_jsonld']) ? 1 : 0,
            'seo.lists.categories.title' => trim($_POST['seo_lists_categories_title'] ?? ''),
            'seo.lists.categories.description' => trim($_POST['seo_lists_categories_desc'] ?? ''),
            'seo.lists.categories.jsonld' => isset($_POST['seo_lists_categories_jsonld']) ? 1 : 0,
            'seo.lists.exchanges.title' => trim($_POST['seo_lists_exchanges_title'] ?? ''),
            'seo.lists.exchanges.description' => trim($_POST['seo_lists_exchanges_desc'] ?? ''),
            'seo.lists.exchanges.jsonld' => isset($_POST['seo_lists_exchanges_jsonld']) ? 1 : 0,
            'seo.snapshots.enable_lists' => isset($_POST['seo_snapshots_enable_lists']) ? 1 : 0,
            'seo.snapshots.ttl.coins' => (int)($_POST['seo_snapshots_ttl_coins'] ?? 10800),
            'seo.snapshots.ttl.categories' => (int)($_POST['seo_snapshots_ttl_categories'] ?? 21600),
            'seo.snapshots.ttl.exchanges' => (int)($_POST['seo_snapshots_ttl_exchanges'] ?? 21600),
            'mail.from' => trim($_POST['mail_from'] ?? ''),
            'mail.transport' => trim($_POST['mail_transport'] ?? 'mail'),
            'mail.smtp.host' => trim($_POST['mail_smtp_host'] ?? ''),
            'mail.smtp.port' => (int)($_POST['mail_smtp_port'] ?? 587),
            'mail.smtp.user' => trim($_POST['mail_smtp_user'] ?? ''),
            'mail.smtp.pass' => trim($_POST['mail_smtp_pass'] ?? ''),
            'mail.smtp.secure' => trim($_POST['mail_smtp_secure'] ?? 'starttls'),
        ];
        foreach ($pairs2 as $k => $v) { $upsert->execute([':k'=>$k, ':v'=>json_encode($v)]); }

        // reCAPTCHA
        $pairs3 = [
            'recaptcha.enabled' => isset($_POST['recaptcha_enabled']) ? 1 : 0,
            'recaptcha.site_key' => trim($_POST['recaptcha_site_key'] ?? ''),
            'recaptcha.secret' => trim($_POST['recaptcha_secret'] ?? ''),
        ];
        foreach ($pairs3 as $k => $v) { $upsert->execute([':k'=>$k, ':v'=>json_encode($v)]); }

        header('Location: /admin/settings?token=' . urlencode($_GET['token'] ?? ''));
    }
}
