<?php
namespace App\Controllers;

use App\Auth;
use App\View;
use App\Database;

class AlertsController
{
    public function index(): void
    {
        $user = Auth::requireUser();
        $pdo = Database::pdo();
        $alerts = $pdo->prepare('SELECT a.*, c.slug, c.name, c.symbol FROM alerts a LEFT JOIN coins c ON c.id = a.coin_id WHERE a.user_id = :u ORDER BY a.id DESC');
        $alerts->execute([':u'=>(int)$user['id']]);
        echo View::render('alerts/index', [
            'title' => 'Alerts — BlocFolio',
            'alerts' => $alerts->fetchAll(),
            'csrf' => Auth::csrfToken(),
        ]);
    }

    public function create(): void
    {
        $user = Auth::requireUser();
        if (!Auth::checkCsrf($_POST['csrf'] ?? '')) { http_response_code(400); echo 'Bad CSRF'; return; }
        $slug = strtolower(trim($_POST['slug'] ?? ''));
        $type = $_POST['type'] ?? 'price';
        $val = (float)($_POST['value'] ?? 0);
        if (!$slug || !$type || !$val) { header('Location: /alerts'); return; }
        $pdo = Database::pdo();
        $coinId = (int)$pdo->prepare('SELECT id FROM coins WHERE slug = :s LIMIT 1')->execute([':s'=>$slug]) ?: 0;
        $stmt = $pdo->prepare('SELECT id FROM coins WHERE slug = :s LIMIT 1');
        $stmt->execute([':s'=>$slug]);
        $coinId = (int)$stmt->fetchColumn();
        if (!$coinId) { header('Location: /alerts'); return; }
        $payload = null;
        if ($type === 'price') $payload = ['op'=>$_POST['op'] ?? 'above','price'=>$val,'currency'=>'usd'];
        if ($type === 'pct') $payload = ['window'=>'24h','op'=>$_POST['op'] ?? 'above','pct'=>$val];
        if (!$payload) { header('Location: /alerts'); return; }
        $pdo->prepare('INSERT INTO alerts (user_id, coin_id, type, condition_json, is_active) VALUES (:u,:c,:t,:j,1)')
            ->execute([':u'=>(int)$user['id'], ':c'=>$coinId, ':t'=>$type, ':j'=>json_encode($payload)]);
        header('Location: /alerts');
    }

    public function delete(): void
    {
        $user = Auth::requireUser();
        if (!Auth::checkCsrf($_POST['csrf'] ?? '')) { http_response_code(400); echo 'Bad CSRF'; return; }
        $id = (int)($_POST['id'] ?? 0);
        if ($id) {
            Database::pdo()->prepare('DELETE FROM alerts WHERE id = :id AND user_id = :u')->execute([':id'=>$id, ':u'=>(int)$user['id']]);
        }
        header('Location: /alerts');
    }
}

