<?php
namespace App\Controllers\Api;

use App\Models\Category;

class CategoriesApiController
{
    public function list(): void
    {
        $draw = (int)($_GET['draw'] ?? 1);
        $start = max(0, (int)($_GET['start'] ?? 0));
        $length = min(100, max(10, (int)($_GET['length'] ?? 25)));
        $search = $_GET['search']['value'] ?? null;
        $orderColIdx = (int)($_GET['order'][0]['column'] ?? 1);
        $orderDir = strtolower($_GET['order'][0]['dir'] ?? 'desc');
        $columns = ['name','market_cap','volume_24h','num_coins'];
        $sort = $columns[$orderColIdx] ?? 'market_cap';
        [$rows,$total,$filtered] = Category::dataTable($start,$length,$sort,$orderDir,$search);
        header('Content-Type: application/json');
        echo json_encode(['draw'=>$draw,'recordsTotal'=>$total,'recordsFiltered'=>$filtered,'data'=>$rows]);
    }

    public function coins(string $slug): void
    {
        $cat = \App\Models\Category::findBySlug($slug);
        if (!$cat) { http_response_code(404); echo json_encode(['error'=>'Not found']); return; }
        $draw = (int)($_GET['draw'] ?? 1);
        $start = max(0, (int)($_GET['start'] ?? 0));
        $length = min(100, max(10, (int)($_GET['length'] ?? 25)));
        $search = $_GET['search']['value'] ?? null;
        $orderColIdx = (int)($_GET['order'][0]['column'] ?? 0);
        $orderDir = strtolower($_GET['order'][0]['dir'] ?? 'asc');
        $columns = ['rank','name','price','change_24h','market_cap','volume_24h'];
        $sort = $columns[$orderColIdx] ?? 'rank';
        [$rows,$total,$filtered] = Category::coinsForCategory((int)$cat['id'],$start,$length,$sort,$orderDir,$search);
        header('Content-Type: application/json');
        echo json_encode(['draw'=>$draw,'recordsTotal'=>$total,'recordsFiltered'=>$filtered,'data'=>$rows]);
    }
}

