<?php
namespace App\Controllers\Api;

use App\Models\Coin;

class CoinsApiController
{
    public function index(): void
    {
        // DataTables server-side parameters
        $draw = (int)($_GET['draw'] ?? 1);
        $start = max(0, (int)($_GET['start'] ?? 0));
        $length = min(100, max(10, (int)($_GET['length'] ?? 25)));
        $search = $_GET['search']['value'] ?? null;
        $orderColIdx = (int)($_GET['order'][0]['column'] ?? 0);
        $orderDir = strtolower($_GET['order'][0]['dir'] ?? 'asc');

        $columns = ['rank','name','price','change_24h','market_cap','volume_24h'];
        $sort = $columns[$orderColIdx] ?? 'rank';

        [$rows, $total, $filtered] = Coin::dataTable($start, $length, $sort, $orderDir, $search);

        header('Content-Type: application/json');
        echo json_encode([
            'draw' => $draw,
            'recordsTotal' => $total,
            'recordsFiltered' => $filtered,
            'data' => $rows,
        ]);
    }
}

