<?php
namespace App\Controllers\Api;

use App\Models\Exchange;

class ExchangesApiController
{
    public function list(): void
    {
        $draw = (int)($_GET['draw'] ?? 1);
        $start = max(0, (int)($_GET['start'] ?? 0));
        $length = min(100, max(10, (int)($_GET['length'] ?? 25)));
        $search = $_GET['search']['value'] ?? null;
        $orderColIdx = (int)($_GET['order'][0]['column'] ?? 0);
        $orderDir = strtolower($_GET['order'][0]['dir'] ?? 'desc');
        $columns = ['name','trust_score','volume_24h'];
        $sort = $columns[$orderColIdx] ?? 'trust_score';
        [$rows,$total,$filtered] = Exchange::dataTable($start,$length,$sort,$orderDir,$search);
        header('Content-Type: application/json');
        echo json_encode([
            'draw'=>$draw,'recordsTotal'=>$total,'recordsFiltered'=>$filtered,'data'=>$rows
        ]);
    }

    public function markets(string $slug): void
    {
        $draw = (int)($_GET['draw'] ?? 1);
        $start = max(0, (int)($_GET['start'] ?? 0));
        $length = min(100, max(10, (int)($_GET['length'] ?? 25)));
        $search = $_GET['search']['value'] ?? null;
        $orderColIdx = (int)($_GET['order'][0]['column'] ?? 2);
        $orderDir = strtolower($_GET['order'][0]['dir'] ?? 'desc');
        $columns = ['pair','last_price','volume_24h'];
        $sort = $columns[$orderColIdx] ?? 'volume_24h';
        $ex = \App\Models\Exchange::findBySlug($slug);
        if (!$ex) { http_response_code(404); echo json_encode(['error'=>'Not found']); return; }
        [$rows,$total,$filtered] = Exchange::marketsByExchangeId((int)$ex['id'],$start,$length,$sort,$orderDir,$search);
        header('Content-Type: application/json');
        echo json_encode(['draw'=>$draw,'recordsTotal'=>$total,'recordsFiltered'=>$filtered,'data'=>$rows]);
    }
}

