<?php
namespace App\Controllers\Api;

use App\Models\OHLC;

class OHLCController
{
    public function bySlug(string $slug): void
    {
        $interval = $_GET['interval'] ?? '1d';
        $limit = max(30, min(2000, (int)($_GET['limit'] ?? 365)));
        $currency = $_GET['currency'] ?? null;

        if (!in_array($interval, ['1d','4h','1h'], true)) { $interval = '1d'; }

        $rows = OHLC::getBySlug($slug, $interval, $currency, $limit);
        $series = array_map(function($r){
            return [
                $r['t'], (float)$r['o'], (float)$r['h'], (float)$r['l'], (float)$r['c'], isset($r['v'])?(float)$r['v']:null
            ];
        }, $rows);

        header('Content-Type: application/json');
        echo json_encode(['interval' => $interval, 'currency' => $currency, 'data' => $series]);
    }
}
