<?php
namespace App\Controllers;

use App\View;
use App\Models\Coin;
use App\Config;

class CompareController
{
    public function show(string $pair): void
    {
        // Expect format a-vs-b
        $parts = explode('-vs-', strtolower(trim($pair)));
        if (count($parts) !== 2) {
            http_response_code(400);
            echo View::render('errors/404', ['title'=>'Bad compare']);
            return;
        }
        [$aSlug, $bSlug] = $parts;
        $a = Coin::findBySlug($aSlug);
        $b = Coin::findBySlug($bSlug);
        if (!$a || !$b) {
            http_response_code(404);
            echo View::render('errors/404', ['title' => 'Compare Not Found']);
            return;
        }
        $currency = Config::get('app.currency_default','USD');
        echo View::render('compare/show', [
            'title' => "{$a['symbol']} vs {$b['symbol']} — BlocFolio",
            'a' => $a, 'b' => $b, 'currency'=>$currency,
        ]);
    }
}

