<?php
namespace App;

class Mailer
{
    public static function send(string $to, string $subject, string $body): bool
    {
        $from = Config::get('mail.from', 'no-reply@example.com');
        $transport = strtolower(Config::get('mail.transport', 'mail'));
        if ($transport === 'smtp') {
            return self::smtpSend($to, $subject, $body, $from);
        }
        $headers = 'From: ' . $from . "\r\n" . 'Content-Type: text/plain; charset=UTF-8';
        return @mail($to, $subject, $body, $headers);
    }

    private static function smtpSend(string $to, string $subject, string $body, string $from): bool
    {
        $host = Config::get('mail.smtp.host');
        $port = (int)Config::get('mail.smtp.port', 587);
        $user = Config::get('mail.smtp.user');
        $pass = Config::get('mail.smtp.pass');
        $secure = strtolower(Config::get('mail.smtp.secure', 'starttls'));
        $timeout = 10;
        $remote = ($secure === 'ssl') ? 'ssl://' . $host : $host;
        $fp = @stream_socket_client($remote . ':' . $port, $errno, $errstr, $timeout, STREAM_CLIENT_CONNECT);
        if (!$fp) return false;
        $read = function() use ($fp){ return fgets($fp, 515); };
        $write = function($cmd) use ($fp){ fwrite($fp, $cmd . "\r\n"); };
        $code = function($line){ return (int)substr($line,0,3); };
        $line = $read(); if ($code($line) !== 220) { fclose($fp); return false; }
        $write('EHLO blocfolio'); $line = $read(); if ($code($line) !== 250) { fclose($fp); return false; }
        if ($secure === 'starttls') {
            $write('STARTTLS'); $line=$read(); if ($code($line)!==220){ fclose($fp); return false; }
            if (!stream_socket_enable_crypto($fp, true, STREAM_CRYPTO_METHOD_TLS_CLIENT)) { fclose($fp); return false; }
            $write('EHLO blocfolio'); $read();
        }
        if ($user && $pass) {
            $write('AUTH LOGIN'); $line=$read(); if ($code($line)!==334){ fclose($fp); return false; }
            $write(base64_encode($user)); $read();
            $write(base64_encode($pass)); $line=$read(); if ($code($line)!==235){ fclose($fp); return false; }
        }
        $write('MAIL FROM:<' . $from . '>'); $read();
        $write('RCPT TO:<' . $to . '>'); $read();
        $write('DATA'); $read();
        $headers = 'From: ' . $from . "\r\n" . 'To: ' . $to . "\r\n" . 'Subject: ' . $subject . "\r\n" . "Content-Type: text/plain; charset=UTF-8\r\n" . "\r\n";
        $write($headers . $body . "\r\n."); $line=$read();
        $write('QUIT'); fclose($fp);
        return true;
    }
}
