<?php
namespace App\Models;

use App\Database;
use App\Config;
use PDO;

class OHLC
{
    public static function getBySlug(string $slug, string $interval = '1d', string $currency = null, int $limit = 365): array
    {
        $pdo = Database::pdo();
        $currency = strtolower($currency ?: Config::get('app.currency_default', 'USD'));
        $table = match ($interval) {
            '1h' => 'coin_ohlc_1h',
            '4h' => 'coin_ohlc_4h',
            default => 'coin_ohlc_1d',
        };
        $sql = "
            SELECT o.t, o.o, o.h, o.l, o.c, o.v
            FROM {$table} o
            JOIN coins c ON c.id = o.coin_id
            WHERE c.slug = :slug AND o.currency = :currency
            ORDER BY o.t ASC
            LIMIT :limit
        ";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':slug', $slug);
        $stmt->bindValue(':currency', $currency);
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll();
    }
}
