<?php
namespace App\Models;

use App\Database;
use PDO;

class Watchlist
{
    public static function defaultIdForUser(int $userId): int
    {
        $pdo = Database::pdo();
        // Try existing default
        $stmt = $pdo->prepare('SELECT id FROM watchlists WHERE user_id = :u AND is_default = 1 LIMIT 1');
        $stmt->execute([':u'=>$userId]);
        $id = (int)$stmt->fetchColumn();
        if ($id) return $id;
        // Create default
        $pdo->prepare('UPDATE watchlists SET is_default = 0 WHERE user_id = :u')->execute([':u'=>$userId]);
        $pdo->prepare('INSERT INTO watchlists (user_id, name, is_default) VALUES (:u, :n, 1)')->execute([':u'=>$userId, ':n'=>'My Watchlist']);
        return (int)$pdo->lastInsertId();
    }

    public static function isIn(int $watchlistId, int $coinId): bool
    {
        $pdo = Database::pdo();
        $stmt = $pdo->prepare('SELECT 1 FROM watchlist_items WHERE watchlist_id = :w AND coin_id = :c LIMIT 1');
        $stmt->execute([':w'=>$watchlistId, ':c'=>$coinId]);
        return (bool)$stmt->fetchColumn();
    }

    public static function add(int $watchlistId, int $coinId): void
    {
        $pdo = Database::pdo();
        $pdo->prepare('INSERT IGNORE INTO watchlist_items (watchlist_id, coin_id) VALUES (:w,:c)')->execute([':w'=>$watchlistId, ':c'=>$coinId]);
    }

    public static function remove(int $watchlistId, int $coinId): void
    {
        $pdo = Database::pdo();
        $pdo->prepare('DELETE FROM watchlist_items WHERE watchlist_id = :w AND coin_id = :c')->execute([':w'=>$watchlistId, ':c'=>$coinId]);
    }

    public static function membershipForSlugs(int $userId, array $slugs): array
    {
        if (empty($slugs)) return [];
        $pdo = Database::pdo();
        $wlId = self::defaultIdForUser($userId);
        $in = implode(',', array_fill(0, count($slugs), '?'));
        $sql = "SELECT c.slug FROM watchlist_items wi JOIN coins c ON c.id = wi.coin_id WHERE wi.watchlist_id = ? AND c.slug IN ($in)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(array_merge([$wlId], $slugs));
        return array_map(fn($r)=>$r['slug'], $stmt->fetchAll());
    }
}

