<?php
namespace App;

class Utils
{
    public static function e(?string $v): string { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
    public static function slug(string $s): string { $s = strtolower(trim($s)); $s = preg_replace('/[^a-z0-9]+/','-',$s); return trim($s,'-'); }
    public static function url(string $path): string { return rtrim(Config::get('app.base_url',''),'/').$path; }
    public static function money($n, string $currency = 'USD'): string { return number_format((float)$n, 2); }

    public static function usernameSlug(array $user): string
    {
        $base = $user['name'] ?? '';
        if (!$base) {
            $email = $user['email'] ?? '';
            $base = strstr($email, '@', true) ?: $email;
        }
        return self::slug($base ?: ('u'.$user['id']));
    }
}
