<?php
namespace App;

class View
{
    public static function render(string $view, array $data = []): string
    {
        $viewPath = __DIR__ . '/Views/' . $view . '.php';
        if (!file_exists($viewPath)) {
            if (Config::get('app.env') !== 'prod') {
                return "View not found: " . htmlspecialchars($view);
            }
            return '';
        }
        extract($data, EXTR_SKIP);
        ob_start();
        include $viewPath;
        $content = ob_get_clean();
        // wrap in layout
        $title = $data['title'] ?? 'BlocFolio';
        $meta = $data['meta'] ?? [];
        ob_start();
        include __DIR__ . '/Views/layout.php';
        return ob_get_clean();
    }
}
