<div class="container" style="max-width:900px">
  <h1 class="h3 mb-3">Jobs</h1>
  <form method="post" action="/admin/jobs/enqueue?token=<?= htmlspecialchars($token) ?>" class="mb-3 d-flex gap-2">
    <select class="form-select" name="type" style="max-width:240px">
      <option value="sitemap_build">Build Sitemaps</option>
      <option value="notifications_send">Send Notifications</option>
    </select>
    <button class="btn btn-light">Enqueue</button>
  </form>
  <div class="card p-2">
    <div class="table-responsive">
      <table class="table table-dark table-sm align-middle mb-0">
        <thead><tr><th>ID</th><th>Type</th><th>Status</th><th>Retries</th><th>Not Before</th><th>Updated</th><th>Error</th></tr></thead>
        <tbody>
        <?php foreach ($jobs as $j): ?>
          <tr>
            <td><?= (int)$j['id'] ?></td>
            <td><?= htmlspecialchars($j['type']) ?></td>
            <td><?= htmlspecialchars($j['status']) ?></td>
            <td><?= (int)$j['retries'] ?></td>
            <td class="small text-muted"><?= htmlspecialchars($j['not_before'] ?? '') ?></td>
            <td class="small text-muted"><?= htmlspecialchars($j['updated_at'] ?? '') ?></td>
            <td class="small text-danger"><?= htmlspecialchars($j['last_error'] ?? '') ?></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

