<div class="d-flex align-items-center mb-3">
  <h1 class="h3 m-0">Analysis</h1>
</div>

<script>
  (async function(){
    const el = document.getElementById('heatmap');
    if (!el || !window.echarts) return;
    const chart = echarts.init(el);
    const res = await fetch('/api/analysis/heatmap');
    const json = await res.json();
    const data = (json.data||[]).map(r=>({
      name: (r.symbol||'').toUpperCase(),
      value: Number(r.market_cap||0),
      change: Number(r.change_24h||0),
      slug: r.slug
    }));
    const seriesData = data.map(d=>({
      name: d.name,
      value: d.value,
      slug: d.slug,
      itemStyle: { color: d.change>=0? '#1fb978' : '#e34d59' }
    }));
    chart.setOption({
      tooltip: { formatter: p => {
        const d = data[p.dataIndex];
        return `${d.name}<br>MC: $${(d.value).toLocaleString()}<br>24h: ${d.change.toFixed(2)}%`;
      }},
      series: [{
        type:'treemap',
        roam: false,
        nodeClick: false,
        breadcrumb: { show: false },
        data: seriesData,
        label: { show:true, formatter: p=> p.name },
      }]
    });
    chart.getZr().on('click', params => {
      const pt = chart.convertFromPixel({seriesIndex:0}, [params.offsetX, params.offsetY]);
      const idx = chart.dispatchAction({type:'highlight'}); // no-op ensures layout
    });
    chart.on('click', function(params){ if(params.data && params.data.slug){ window.location = '/coins/' + params.data.slug; } });
  })();

  (async function(){
    try {
      const r = await fetch('/api/analysis/breadth'); const j = await r.json();
      document.getElementById('breadth').textContent = (j.pct_adv||0) + '% advancing';
      document.getElementById('breadthMeta').textContent = `${j.adv||0} adv / ${j.dec||0} dec out of ${j.total||0}`;
    } catch(e){}
  })();

  (async function(){
    try { const r = await fetch('/api/analysis/volatility'); const j = await r.json(); const tb = document.querySelector('#voltab tbody');
      (j.data||[]).forEach(x=>{ const tr=document.createElement('tr'); tr.innerHTML = `<td><a class=\"text-decoration-none\" href=\"/coins/${x.slug}\"><strong>${x.name}</strong> <span class=\"text-muted\">(${(x.symbol||'').toUpperCase()})</span></a></td><td class=\"text-end\">${Number(x.stddev||0).toFixed(4)}</td>`; tb.appendChild(tr); });
    }catch(e){}
  })();

  (async function(){
    try { const r = await fetch('/api/analysis/highs-lows'); const j = await r.json(); const hi=document.getElementById('highs'); const lo=document.getElementById('lows');
      (j.highs||[]).forEach(x=>{ const li=document.createElement('li'); li.innerHTML = `<a class=\"text-decoration-none\" href=\"/coins/${x.slug}\"><strong>${x.name}</strong></a> <span class=\"text-muted\">(${(x.symbol||'').toUpperCase()})</span>`; hi.appendChild(li); });
      (j.lows||[]).forEach(x=>{ const li=document.createElement('li'); li.innerHTML = `<a class=\"text-decoration-none\" href=\"/coins/${x.slug}\"><strong>${x.name}</strong></a> <span class=\"text-muted\">(${(x.symbol||'').toUpperCase()})</span>`; lo.appendChild(li); });
    }catch(e){}
  })();

  (async function(){
    try { const r = await fetch('/api/analysis/volume-surge'); const j = await r.json(); const tb=document.querySelector('#volsurge tbody');
      (j.data||[]).forEach(x=>{ const tr=document.createElement('tr'); tr.innerHTML = `<td><a class=\"text-decoration-none\" href=\"/coins/${x.slug}\"><strong>${x.name}</strong> <span class=\"text-muted\">(${(x.symbol||'').toUpperCase()})</span></a></td><td class=\"text-end\">$${Number(x.vol||0).toLocaleString()}</td><td class=\"text-end\">$${Number(x.avg_vol||0).toLocaleString()}</td><td class=\"text-end\">${Number(x.ratio||0).toFixed(2)}x</td>`; tb.appendChild(tr); });
    }catch(e){}
  })();
</script>
<div class="row g-3">
  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Top Gainers (24h)</div>
      <div class="table-responsive">
        <table class="table table-dark table-sm align-middle mb-0">
          <thead><tr><th>Coin</th><th class="text-end">Price</th><th class="text-end">24h %</th></tr></thead>
          <tbody>
          <?php foreach ($gainers as $g): ?>
            <tr>
              <td><a class="text-decoration-none" href="/coins/<?= htmlspecialchars($g['slug']) ?>"><strong><?= htmlspecialchars($g['name']) ?></strong> <span class="text-muted">(<?= htmlspecialchars(strtoupper($g['symbol'])) ?>)</span></a></td>
              <td class="text-end"><?= $g['price']!==null?('$'.number_format((float)$g['price'],6)):'—' ?></td>
              <td class="text-end"><span class="up"><?= number_format((float)$g['change_24h'],2) ?>%</span></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Top Losers (24h)</div>
      <div class="table-responsive">
        <table class="table table-dark table-sm align-middle mb-0">
          <thead><tr><th>Coin</th><th class="text-end">Price</th><th class="text-end">24h %</th></tr></thead>
          <tbody>
          <?php foreach ($losers as $g): ?>
            <tr>
              <td><a class="text-decoration-none" href="/coins/<?= htmlspecialchars($g['slug']) ?>"><strong><?= htmlspecialchars($g['name']) ?></strong> <span class="text-muted">(<?= htmlspecialchars(strtoupper($g['symbol'])) ?>)</span></a></td>
              <td class="text-end"><?= $g['price']!==null?('$'.number_format((float)$g['price'],6)):'—' ?></td>
              <td class="text-end"><span class="down"><?= number_format((float)$g['change_24h'],2) ?>%</span></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <div class="col-12">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Market Cap Heatmap (Top 200)</div>
      <div id="heatmap" style="height: 520px;"></div>
    </div>
  </div>
  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Market Breadth (Advancers)</div>
      <div id="breadth" class="fs-4"></div>
      <div class="small text-muted" id="breadthMeta"></div>
    </div>
  </div>
  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Volatility Leaders (30d)</div>
      <div class="table-responsive" style="max-height:260px;overflow:auto">
        <table class="table table-dark table-sm mb-0" id="voltab"><thead><tr><th>Coin</th><th class="text-end">Stdev</th></tr></thead><tbody></tbody></table>
      </div>
    </div>
  </div>
  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">New Highs (52w)</div>
      <ul class="m-0" id="highs"></ul>
    </div>
  </div>
  <div class="col-12 col-lg-6">
    <div class="card p-3">
      <div class="fw-semibold mb-2">New Lows (52w)</div>
      <ul class="m-0" id="lows"></ul>
    </div>
  </div>
  <div class="col-12">
    <div class="card p-3">
      <div class="fw-semibold mb-2">Volume Surge (last 24h vs avg)</div>
      <div class="table-responsive" style="max-height:260px;overflow:auto">
        <table class="table table-dark table-sm mb-0" id="volsurge"><thead><tr><th>Coin</th><th class="text-end">Current</th><th class="text-end">Avg 24h</th><th class="text-end">x</th></tr></thead><tbody></tbody></table>
      </div>
    </div>
  </div>
</div>
