<?php $cat = $category; ?>
<div class="d-flex align-items-center mb-3">
  <h1 class="h3 m-0"><?= htmlspecialchars($cat['name']) ?></h1>
  <span class="ms-3 badge badge-gold">Coins: <?= (int)($cat['num_coins'] ?? 0) ?></span>
  <div class="ms-auto small text-muted">MCap: <?= $cat['market_cap']!==null ? ('$'.number_format((float)$cat['market_cap'])) : '—' ?>
    • Vol 24h: <?= $cat['volume_24h']!==null ? ('$'.number_format((float)$cat['volume_24h'])) : '—' ?></div>
</div>

<div class="card p-2">
  <div class="table-responsive">
    <table id="cat-coins" class="table table-dark table-hover align-middle mb-0" style="width:100%">
      <thead>
      <tr>
        <th>Rank</th>
        <th>Name</th>
        <th class="text-end">Price</th>
        <th class="text-end">24h %</th>
        <th class="text-end">Market Cap</th>
        <th class="text-end">Volume 24h</th>
      </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>

<script>
  const table = new DataTable('#cat-coins', {
    serverSide:true, processing:true,
    ajax:'/api/categories/<?= htmlspecialchars($cat['slug']) ?>/coins',
    order:[[0,'asc']], pageLength:25,
    columns:[
      {data:'rank'},
      {data:null, render: r=>`<a class='text-decoration-none' href='/coins/${r.slug}'><strong>${r.name}</strong> <span class='text-muted'>(${(r.symbol||'').toUpperCase()})</span></a>`},
      {data:'price', className:'text-end', render:d=> d!=null?('$'+Number(d).toLocaleString(undefined,{maximumFractionDigits:6})): '—'},
      {data:'change_24h', className:'text-end', render: d=> d!=null?`<span class='${d>=0?'up':'down'}'>${Number(d).toFixed(2)}%</span>`:'—'},
      {data:'market_cap', className:'text-end', render:d=> d!=null?('$'+Number(d).toLocaleString()):'—'},
      {data:'volume_24h', className:'text-end', render:d=> d!=null?('$'+Number(d).toLocaleString()):'—'}
    ]
  });
</script>

