<?php use App\Utils; ?>
<div class="d-flex align-items-center mb-3">
  <h1 class="h3 m-0">Coins</h1>
  <span class="ms-3 badge badge-gold"><?= (int)$total ?> total</span>
  <div class="ms-auto">
    <a class="btn btn-sm btn-outline-light" href="?sort=market_cap&dir=desc">Sort by Market Cap</a>
  </div>
  </div>

<div class="card p-2">
  <div class="d-flex justify-content-end px-2 pt-2">
    <div class="input-group input-group-sm" style="max-width:340px">
      <span class="input-group-text">Target watchlist</span>
      <select id="wl-select" class="form-select"></select>
    </div>
  </div>
  <div class="table-responsive">
    <table id="coins-table" class="table table-dark table-hover align-middle mb-0" style="width:100%">
      <thead>
      <tr>
        <th>Rank</th>
        <th>Name</th>
        <th class="text-end">Price</th>
        <th class="text-end">24h %</th>
        <th class="text-end">Market Cap</th>
        <th class="text-end">Volume 24h</th>
      </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>
</div>

<script>
  // Watchlist helpers
  function attachWatchlistHandlers(){
    document.querySelectorAll('.wl-toggle').forEach(btn=>{
      btn.onclick = async function(){
        const slug = this.getAttribute('data-slug');
        const fd = new FormData(); fd.append('slug', slug); fd.append('csrf', window.CSRF);
        const wlSel = document.getElementById('wl-select'); if (wlSel && wlSel.value) fd.append('watchlist_slug', wlSel.value);
        const res = await fetch('/api/watchlist/toggle', {method:'POST', body:fd});
        if (res.status===401){ alert('Please login to use watchlists'); return; }
        const json = await res.json();
        const on = !!json.in_watchlist;
        this.classList.toggle('btn-warning', on);
        const i = this.querySelector('i'); if(i){ i.classList.toggle('fa-solid', on); }
      };
    });
  }
  async function markMembership(){
    const slugs = Array.from(document.querySelectorAll('.wl-toggle')).map(b=>b.getAttribute('data-slug'));
    if (!slugs.length) return;
    try{
      const wlSel = document.getElementById('wl-select');
      const qs = '/api/watchlist/membership?slugs='+encodeURIComponent(slugs.join(',')) + (wlSel&&wlSel.value?('&watchlist_slug='+encodeURIComponent(wlSel.value)):'');
      const res = await fetch(qs);
      const json = await res.json();
      const set = new Set(json.slugs||[]);
      document.querySelectorAll('.wl-toggle').forEach(b=>{
        const on = set.has(b.getAttribute('data-slug'));
        b.classList.toggle('btn-warning', on);
        const i = b.querySelector('i'); if(i){ i.classList.toggle('fa-solid', on); }
      });
    }catch(e){}
  }

  const table = new DataTable('#coins-table', {
    serverSide: true,
    processing: true,
    ajax: {
      url: '/api/coins',
      data: function(d){
        // pass query search from URL if present
        const params = new URLSearchParams(window.location.search);
        if (params.get('q')) {
          d.search = d.search || {};
          d.search.value = params.get('q');
        }
      }
    },
    columns: [
      { data: 'rank' },
      { data: null, render: function(row){
          const img = row.image_small ? `<img class="logo me-2" src="${row.image_small}" alt="">` : '';
          const link = `<a class="text-decoration-none" href="/coins/${row.slug}">${img}<strong>${row.name}</strong> <span class="text-muted">(${(row.symbol||'').toUpperCase()})</span></a>`;
          const btn = `<button class="btn btn-xs btn-outline-light wl-toggle ms-2" data-slug="${row.slug}" title="Toggle watchlist"><i class="fa fa-star"></i></button>`;
          return `<div class="d-flex align-items-center">${link}${btn}</div>`;
      }},
      { data: 'price', className: 'text-end', render: d => d!=null ? ('$' + Number(d).toLocaleString(undefined,{maximumFractionDigits:4})) : '—' },
      { data: 'change_24h', className: 'text-end', render: function(d){ if(d==null) return '—'; const cls=d>=0?'up':'down'; return `<span class="${cls}">${Number(d).toFixed(2)}%</span>`; } },
      { data: 'market_cap', className: 'text-end', render: d => d!=null ? ('$' + Number(d).toLocaleString()) : '—' },
      { data: 'volume_24h', className: 'text-end', render: d => d!=null ? ('$' + Number(d).toLocaleString()) : '—' },
    ],
    order: [[0,'asc']],
    pageLength: <?= (int)($limit ?? 25) ?>,
    drawCallback: function(){ attachWatchlistHandlers(); markMembership(); }
  });

  // Load user's watchlists for selector
  async function loadWatchlists(){
    try{
      const res = await fetch('/api/watchlists');
      const json = await res.json();
      const sel = document.getElementById('wl-select'); sel.innerHTML='';
      (json.lists||[]).forEach(l=>{
        const opt = document.createElement('option'); opt.value=l.slug; opt.textContent=l.name + (l.is_default?' (default)':''); sel.appendChild(opt);
      });
    }catch(e){}
  }
  loadWatchlists();
</script>
