<?php use App\Utils; ?>
<?php $c = $coin; ?>
<div class="row g-3">
  <div class="col-12">
    <div class="d-flex align-items-center">
      <?php if (!empty($c['image_small'])): ?>
        <img class="logo me-2" src="<?= Utils::e($c['image_small']) ?>" alt="">
      <?php endif; ?>
      <h1 class="h3 m-0">
        <?= Utils::e($c['name'] ?? 'Coin') ?>
        <span class="text-muted">(<?= Utils::e(strtoupper($c['symbol'] ?? '')) ?>)</span>
      </h1>
      <?php if (!empty($c['rank'])): ?><span class="ms-3 badge badge-gold">Rank #<?= (int)$c['rank'] ?></span><?php endif; ?>
      <button class="btn btn-sm btn-outline-light ms-3 wl-toggle" data-slug="<?= Utils::e($c['slug']) ?>" title="Toggle watchlist"><i class="fa fa-star"></i> Watch</button>
      <div class="ms-auto text-end">
        <div class="fs-4">
          <?= $c['price'] !== null ? ('$' . number_format((float)$c['price'], 6)) : '—' ?>
        </div>
        <div class="small text-muted">Updated: <?= !empty($c['snapshot_at']) ? Utils::e($c['snapshot_at']) : '—' ?></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center mb-2">
        <div class="fw-semibold">Price Chart</div>
        <div class="d-flex align-items-center gap-2">
          <div class="btn-group btn-group-sm" role="group">
            <a href="#" class="btn btn-outline-light" data-intv="1h">1h</a>
            <a href="#" class="btn btn-outline-light" data-intv="4h">4h</a>
            <a href="#" class="btn btn-outline-light active" data-intv="1d">1d</a>
          </div>
          <div class="form-check form-check-inline small">
            <input class="form-check-input" type="checkbox" id="ma5" checked>
            <label class="form-check-label" for="ma5">MA5</label>
          </div>
          <div class="form-check form-check-inline small">
            <input class="form-check-input" type="checkbox" id="ma20">
            <label class="form-check-label" for="ma20">MA20</label>
          </div>
          <div class="form-check form-check-inline small">
            <input class="form-check-input" type="checkbox" id="ma50">
            <label class="form-check-label" for="ma50">MA50</label>
          </div>
          <div class="form-check form-check-inline small">
            <input class="form-check-input" type="checkbox" id="scaleLog">
            <label class="form-check-label" for="scaleLog">Log</label>
          </div>
        </div>
      </div>
      <div id="chart" style="height: 420px;"></div>
    </div>
  </div>
  <div class="col-12 col-lg-4">
    <div class="card p-3">
      <div class="mb-2 fw-semibold">Key Stats</div>
      <div class="d-flex justify-content-between"><span>Market Cap</span><span><?= $c['market_cap'] !== null ? ('$' . number_format((float)$c['market_cap'])) : '—' ?></span></div>
      <div class="d-flex justify-content-between"><span>24h Volume</span><span><?= $c['volume_24h'] !== null ? ('$' . number_format((float)$c['volume_24h'])) : '—' ?></span></div>
      <div class="d-flex justify-content-between"><span>24h Change</span>
        <?php $p = $c['change_24h']; $cls = ($p === null) ? '' : (($p >= 0) ? 'up' : 'down'); ?>
        <span class="<?= $cls ?>"><?= $p !== null ? number_format((float)$p, 2) . '%' : '—' ?></span>
      </div>
      <?php if (!empty($c['ath_drawdown'])): ?>
        <div class="d-flex justify-content-between"><span>From ATH</span>
          <span class="down"><?= number_format((float)$c['ath_drawdown'], 2) ?>%</span>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <div class="col-12">
    <div class="card p-3">
      <div class="mb-2 fw-semibold">About</div>
      <div class="small text-muted">HTML from CoinGecko (sanitized/limited in production).</div>
      <div class="mt-2">
        <?php
          if (!empty($c['description_html'])) {
              $allowed = '<p><ul><ol><li><a><strong><em><code><br><hr><h2><h3><h4><blockquote>';
              echo strip_tags($c['description_html'], $allowed);
          } else {
              echo '<em>No description available.</em>';
          }
        ?>
      </div>
    </div>
  </div>
</div>

<script>
  // Watchlist toggle for coin page
  (function(){
    const btn = document.querySelector('.wl-toggle[data-slug]');
    async function refresh(){
      try{
        const slug = btn.getAttribute('data-slug');
        const res = await fetch('/api/watchlist/membership?slugs='+encodeURIComponent(slug));
        const json = await res.json();
        const on = (json.slugs||[]).includes(slug);
        btn.classList.toggle('btn-warning', on);
        const i = btn.querySelector('i'); if(i){ i.classList.toggle('fa-solid', on); }
      }catch(e){}
    }
    if (btn){
      btn.addEventListener('click', async function(){
        const fd = new FormData(); fd.append('slug', this.getAttribute('data-slug')); fd.append('csrf', window.CSRF);
        const res = await fetch('/api/watchlist/toggle', {method:'POST', body: fd});
        if (res.status===401){ alert('Please login to use watchlists'); return; }
        refresh();
      });
      refresh();
    }
  })();

  // Load OHLC daily data and render candlestick with volume
  (function(){
    const el = document.getElementById('chart');
    if (!el || !window.echarts) return;
    const chart = echarts.init(el);
    const slug = <?= json_encode($c['slug'] ?? '') ?>;
    const intvBtns = document.querySelectorAll('[data-intv]');
    let currentIntv = '1d';

    function MA(dayCount, closes){
      const result=[]; for (let i=0;i<closes.length;i++){ if(i<dayCount){ result.push(null); } else { let sum=0; for(let j=0;j<dayCount;j++){ sum+=closes[i-j]; } result.push(sum/dayCount);} } return result;
    }

    async function load(intv){
      currentIntv = intv;
      intvBtns.forEach(b=>b.classList.toggle('active', b.getAttribute('data-intv')===intv));
      const res = await fetch(`/api/coins/${slug}/ohlc?interval=${intv}&limit=${intv==='1d'?365:500}`);
      const json = await res.json();
      const data = json.data || [];
      const categories = data.map(d => d[0]);
      const values = data.map(d => [d[1], d[2], d[3], d[4]]);
      const volumes = data.map(d => d[5]);
      const closes = data.map(d => d[4]);

      const show5 = document.getElementById('ma5').checked;
      const show20 = document.getElementById('ma20').checked;
      const show50 = document.getElementById('ma50').checked;

      const series = [
        {type:'candlestick', name:'OHLC', data: values},
        {type:'bar', name:'Volume', xAxisIndex:1, yAxisIndex:1, data: volumes, itemStyle:{opacity:.5}}
      ];
      if (show5) series.push({type:'line', name:'MA5', data: MA(5, closes), smooth:true, symbol:'none', lineStyle:{opacity:.7}});
      if (show20) series.push({type:'line', name:'MA20', data: MA(20, closes), smooth:true, symbol:'none', lineStyle:{opacity:.7}});
      if (show50) series.push({type:'line', name:'MA50', data: MA(50, closes), smooth:true, symbol:'none', lineStyle:{opacity:.7}});

      const yLog = document.getElementById('scaleLog').checked;
      chart.setOption({
        animation: false,
        tooltip: {trigger: 'axis'},
        axisPointer: {type: 'cross'},
        grid: [{left:40,right:10,top:10,height:260},{left:40,right:10,top:300,height:80}],
        xAxis: [
          {type:'category', data: categories, boundaryGap: false, axisLine:{onZero:false}},
          {type:'category', data: categories, gridIndex:1, boundaryGap:false, axisLabel:{show:false}}
        ],
        yAxis: [
          {scale:true, type: yLog ? 'log' : 'value'},
          {scale:true, gridIndex:1}
        ],
        dataZoom: [{type:'inside', xAxisIndex:[0,1], start:50, end:100},{xAxisIndex:[0,1], start:50, end:100}],
        series
      }, true);
    }

    intvBtns.forEach(btn => btn.addEventListener('click', (e)=>{ e.preventDefault(); load(btn.getAttribute('data-intv')); }));
    ['ma5','ma20','ma50','scaleLog'].forEach(id => document.getElementById(id).addEventListener('change', ()=> load(currentIntv)));
    load('1d');
  })();
</script>
