<?php use App\Utils; ?>
<?php $a=$a; $b=$b; ?>
<div class="d-flex align-items-center mb-3">
  <h1 class="h4 m-0">Compare: <?= Utils::e($a['name']) ?> (<?= strtoupper(Utils::e($a['symbol'])) ?>) vs <?= Utils::e($b['name']) ?> (<?= strtoupper(Utils::e($b['symbol'])) ?>)</h1>
</div>

<div class="card p-3 mb-3">
  <div class="row text-center">
    <div class="col">
      <div class="text-muted small">Price</div>
      <div class="fs-5">$<?= $a['price']!==null?number_format((float)$a['price'],6):'—' ?></div>
    </div>
    <div class="col">
      <div class="text-muted small">Price</div>
      <div class="fs-5">$<?= $b['price']!==null?number_format((float)$b['price'],6):'—' ?></div>
    </div>
    <div class="col">
      <div class="text-muted small">24h %</div>
      <?php $p=$a['change_24h']; $cls=$p>=0?'up':'down'; ?>
      <div class="fs-6 <?= $cls ?>"><?= $p!==null?number_format((float)$p,2).'%':'—' ?></div>
    </div>
    <div class="col">
      <div class="text-muted small">24h %</div>
      <?php $p=$b['change_24h']; $cls=$p>=0?'up':'down'; ?>
      <div class="fs-6 <?= $cls ?>"><?= $p!==null?number_format((float)$p,2).'%':'—' ?></div>
    </div>
  </div>
</div>

<div class="card p-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <div class="fw-semibold">Normalized Price (<?= Utils::e($a['symbol']) ?> = 100 at start)</div>
    <div>
      <div class="btn-group btn-group-sm" role="group">
        <a href="#" class="btn btn-outline-light active" data-intv="1d">1d</a>
        <a href="#" class="btn btn-outline-light" data-intv="4h">4h</a>
        <a href="#" class="btn btn-outline-light" data-intv="1h">1h</a>
      </div>
    </div>
  </div>
  <div id="cmpChart" style="height: 420px;"></div>
</div>

<script>
  (function(){
    const slugA = <?= json_encode($a['slug']) ?>;
    const slugB = <?= json_encode($b['slug']) ?>;
    const chart = echarts.init(document.getElementById('cmpChart'));
    let current='1d';
    async function load(intv){
      current=intv;
      const [ra, rb] = await Promise.all([
        fetch(`/api/coins/${slugA}/ohlc?interval=${intv}&limit=${intv==='1d'?365:500}`).then(r=>r.json()),
        fetch(`/api/coins/${slugB}/ohlc?interval=${intv}&limit=${intv==='1d'?365:500}`).then(r=>r.json())
      ]);
      const da = (ra.data||[]).map(d=>[d[0], d[4]]);
      const db = (rb.data||[]).map(d=>[d[0], d[4]]);
      const dates = da.map(d=>d[0]);
      if (!da.length || !db.length){ chart.clear(); return; }
      const baseA = da[0][1]||1, baseB = db[0][1]||1;
      const normA = da.map(([t,v]) => [t, v/baseA*100]);
      const normB = db.map(([t,v]) => [t, v/baseB*100]);
      chart.setOption({
        grid:{left:40,right:10,top:10,bottom:25},
        tooltip:{trigger:'axis'},
        xAxis:{type:'category', data: dates},
        yAxis:{type:'value', scale:true},
        series:[
          {type:'line', name:'<?= Utils::e(strtoupper($a['symbol'])) ?>', data: normA.map(x=>x[1]), smooth:true, symbol:'none'},
          {type:'line', name:'<?= Utils::e(strtoupper($b['symbol'])) ?>', data: normB.map(x=>x[1]), smooth:true, symbol:'none'}
        ]
      });
    }
    document.querySelectorAll('[data-intv]').forEach(b=> b.addEventListener('click', (e)=>{ e.preventDefault(); document.querySelectorAll('[data-intv]').forEach(x=>x.classList.toggle('active', x===b)); load(b.getAttribute('data-intv')); }));
    load('1d');
  })();
</script>

