<?php /** @var string $content */
use App\Config;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'BlocFolio') ?></title>
  <?php if (!empty($meta['description'])): ?>
    <meta name="description" content="<?= htmlspecialchars($meta['description']) ?>">
  <?php endif; ?>
  <?php if (!empty($meta['canonical'])): ?>
    <link rel="canonical" href="<?= htmlspecialchars($meta['canonical']) ?>">
  <?php else: ?>
    <?php $currentUrl = (App\Config::get('app.base_url') ? rtrim(App\Config::get('app.base_url'),'/') : '') . ($_SERVER['REQUEST_URI'] ?? '/'); ?>
    <link rel="canonical" href="<?= htmlspecialchars($currentUrl) ?>">
  <?php endif; ?>
  <?php if (!empty($meta['og'])): ?>
    <meta property="og:title" content="<?= htmlspecialchars($meta['og']['title'] ?? '') ?>">
    <meta property="og:description" content="<?= htmlspecialchars($meta['og']['description'] ?? '') ?>">
    <?php if (!empty($meta['og']['image'])): ?><meta property="og:image" content="<?= htmlspecialchars($meta['og']['image']) ?>"><?php endif; ?>
    <?php if (!empty($meta['og']['url'])): ?><meta property="og:url" content="<?= htmlspecialchars($meta['og']['url']) ?>"><?php endif; ?>
    <meta property="og:type" content="website">
  <?php endif; ?>
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="<?= Config::get('assets.fonts') ?>" rel="stylesheet">
  <link href="<?= Config::get('assets.bootstrap_css') ?>" rel="stylesheet">
  <link href="<?= Config::get('assets.fontawesome') ?>" rel="stylesheet">
  <link href="<?= Config::get('assets.material_icons') ?>" rel="stylesheet">
  <link href="<?= Config::get('assets.datatables_css') ?>" rel="stylesheet">
  <meta name="csrf-token" content="<?= htmlspecialchars(App\Auth::csrfToken()) ?>">
  <style>
    :root{
      --bg:#0B0B0C; --fg:#f3f3f3; --muted:#9ea3a8; --gold:#C9A959; --cyan:#00e5ff;
    }
    html,body{background:var(--bg); color:var(--fg); font-family: 'Inter', sans-serif;}
    a{color:var(--cyan)} a:hover{color:#7ef;
    }
    .navbar{background:rgba(20,20,22,0.85); backdrop-filter:saturate(120%) blur(6px);}
    .card{background:rgba(255,255,255,0.03); border:1px solid rgba(255,255,255,0.08);} 
    .badge-gold{background:var(--gold); color:#111;}
    .text-muted{color:var(--muted)!important}
    .up{color:#4cd964} .down{color:#ff3b30}
    img.logo{width:24px;height:24px;border-radius:50%;object-fit:cover;}
  </style>
</head>
<body>
<nav class="navbar navbar-expand-lg sticky-top">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="/">BlocFolio</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="nav">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="/coins">Coins</a></li>
        <li class="nav-item"><a class="nav-link" href="/exchanges">Exchanges</a></li>
        <li class="nav-item"><a class="nav-link" href="/categories">Categories</a></li>
        <li class="nav-item"><a class="nav-link" href="/analysis">Analysis</a></li>
      </ul>
      <form class="d-flex" role="search" action="/coins">
        <input class="form-control me-2" type="search" name="q" placeholder="Search coins">
        <button class="btn btn-outline-light" type="submit">Search</button>
      </form>
      <div class="ms-3">
        <?php $u = App\Auth::user(); if ($u): ?>
          <div class="dropdown">
            <a class="btn btn-sm btn-outline-light dropdown-toggle" href="#" data-bs-toggle="dropdown" aria-expanded="false"><?= htmlspecialchars($u['name']?:$u['email']) ?></a>
            <ul class="dropdown-menu dropdown-menu-dark dropdown-menu-end">
              <li><a class="dropdown-item" href="/logout">Logout</a></li>
            </ul>
          </div>
        <?php else: ?>
          <a class="btn btn-sm btn-outline-light" href="/login">Login</a>
          <a class="btn btn-sm btn-light ms-2" href="/register">Register</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="border-bottom border-secondary" style="opacity:.3"></div>
</nav>

<main class="container py-4">
  <?= $content ?>
  <footer class="mt-5 small text-muted">Powered by CoinGecko • © <?= date('Y') ?> BlocFolio</footer>
  <div class="mb-5"></div>
</main>

<script src="<?= Config::get('assets.bootstrap_js') ?>"></script>
<script src="<?= Config::get('assets.datatables_js') ?>"></script>
<script src="<?= Config::get('assets.echarts') ?>"></script>
<script>
  window.CSRF = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
</script>
<?php if (!empty($meta['json_ld'])): ?>
<script type="application/ld+json">
<?= json_encode($meta['json_ld'], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE) ?>
</script>
<?php endif; ?>
<?php if ($ga = App\Config::get('seo.ga4_id')): ?>
<!-- GA4 -->
<script async src="https://www.googletagmanager.com/gtag/js?id=<?= htmlspecialchars($ga) ?>"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', '<?= htmlspecialchars($ga) ?>');
</script>
<?php endif; ?>
<?php if ($rk = App\Config::get('recaptcha.site_key')): ?>
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<?php endif; ?>
</body>
</html>
