<?php
// Pull categories and coin-category mapping from CoinGecko
require __DIR__ . '/../../app/bootstrap.php';
require_once __DIR__ . '/../lib/http.php';
require_once __DIR__ . '/../lib/lock.php';

use App\Database;
use App\Utils;
use App\Snapshot;
use Scripts\Lib\Http;
use Scripts\Lib\HttpException;
use Scripts\Lib\Lock;

if (php_sapi_name() !== 'cli') { echo "Run from CLI\n"; exit(1); }
set_time_limit(0);
ini_set('memory_limit','512M');

$lock = new Lock('categories_pull');
if (!$lock->acquire()) { echo "Another categories_pull is running.\n"; exit(0); }

$pdo = Database::pdo();
$base = 'https://api.coingecko.com/api/v3';

$upsertCat = $pdo->prepare("INSERT INTO categories (cg_id, name, slug, market_cap, volume_24h, num_coins)
VALUES (:cg_id,:name,:slug,:mcap,:vol,:n)
ON DUPLICATE KEY UPDATE name=VALUES(name), slug=VALUES(slug), market_cap=VALUES(market_cap), volume_24h=VALUES(volume_24h), num_coins=VALUES(num_coins), updated_at=NOW()");

// Fetch categories with metrics
try {
    $cats = Http::getJson($base . '/coins/categories', 30);
} catch (HttpException $e) { if ($e->getStatus()===429 && $e->getRetryAfter()) sleep($e->getRetryAfter()); $cats = []; }
  catch (\Throwable $e) { $cats = []; }

foreach ($cats as $c) {
    $cg = $c['id'] ?? $c['category_id'] ?? null; if (!$cg) continue;
    $name = $c['name'] ?? $cg;
    $slug = Utils::slug($name);
    $upsertCat->execute([
        ':cg_id'=>$cg, ':name'=>$name, ':slug'=>$slug,
        ':mcap'=> $c['market_cap'] ?? null, ':vol'=>$c['volume_24h'] ?? null, ':n'=>$c['coin_count'] ?? ($c['content'] ?? null)
    ]);
    // Invalidate category snapshot
    Snapshot::invalidate('/categories/' . $slug);
}

// Invalidate list page snapshot
\App\Snapshot::invalidate('/categories');

// Mapping coin_categories can be filled by a separate job if needed.

echo "categories_pull done\n";
