<?php
// Populate coin_categories by fetching per-coin categories from CoinGecko /coins/{id}
require __DIR__ . '/../../app/bootstrap.php';
require_once __DIR__ . '/../lib/http.php';
require_once __DIR__ . '/../lib/lock.php';

use App\Database;
use App\Utils;
use App\Snapshot;
use Scripts\Lib\Http;
use Scripts\Lib\HttpException;
use Scripts\Lib\Lock;

if (php_sapi_name() !== 'cli') { echo "Run from CLI\n"; exit(1); }
set_time_limit(0);
ini_set('memory_limit','512M');

$lock = new Lock('coin_categories_sync');
if (!$lock->acquire()) { echo "Another coin_categories_sync is running.\n"; exit(0); }

$pdo = Database::pdo();
$base = 'https://api.coingecko.com/api/v3';

$coins = $pdo->query('SELECT id, cg_id, name FROM coins WHERE is_active = 1 ORDER BY rank IS NULL, rank ASC, id ASC LIMIT 500')->fetchAll();

$findCat = $pdo->prepare('SELECT id FROM categories WHERE slug = :slug');
$insertCat = $pdo->prepare('INSERT INTO categories (cg_id, name, slug, market_cap, volume_24h, num_coins) VALUES (:cg_id,:name,:slug,NULL,NULL,NULL)');
$link = $pdo->prepare('REPLACE INTO coin_categories (coin_id, category_id) VALUES (:coin,:cat)');

foreach ($coins as $coin) {
    $cgId = $coin['cg_id']; if (!$cgId) continue;
    $url = $base . '/coins/' . rawurlencode($cgId) . '?localization=false&tickers=false&market_data=false&community_data=false&developer_data=false&sparkline=false';
    try {
        $data = Http::getJson($url, 20);
    } catch (HttpException $e) { if ($e->getStatus()===429 && $e->getRetryAfter()) sleep($e->getRetryAfter()); continue; }
      catch (\Throwable $e) { continue; }

    $cats = $data['categories'] ?? [];
    if (!$cats) continue;

    foreach ($cats as $name) {
        $slug = Utils::slug($name);
        $findCat->execute([':slug'=>$slug]);
        $catId = (int)$findCat->fetchColumn();
        if (!$catId) {
            $insertCat->execute([':cg_id'=>null, ':name'=>$name, ':slug'=>$slug]);
            $catId = (int)$pdo->lastInsertId();
        }
        $link->execute([':coin'=>(int)$coin['id'], ':cat'=>$catId]);
        Snapshot::invalidate('/categories/' . $slug);
    }
}

echo "coin_categories_sync done\n";

