<?php
require __DIR__ . '/../../app/bootstrap.php';

use App\Database;
use App\Mailer;

if (php_sapi_name() !== 'cli') { echo "Run from CLI\n"; exit(1); }

$pdo = Database::pdo();
$limit = 50;
$stmt = $pdo->prepare("SELECT n.id, n.user_id, n.title, n.body, u.email
  FROM notifications n JOIN users u ON u.id = n.user_id
  WHERE n.status = 'queued' AND n.channel = 'email'
  ORDER BY n.id ASC LIMIT :lim");
$stmt->bindValue(':lim', $limit, \PDO::PARAM_INT);
$stmt->execute();
$rows = $stmt->fetchAll();
$ok = 0; $fail = 0;
foreach ($rows as $r) {
    $sent = false;
    try { $sent = Mailer::send($r['email'], $r['title'], $r['body']); } catch (\Throwable $e) { $sent = false; }
    if ($sent) {
        $pdo->prepare("UPDATE notifications SET status='sent' WHERE id = :id")->execute([':id'=>(int)$r['id']]);
        $ok++;
    } else {
        $pdo->prepare("UPDATE notifications SET status='error', error='mail_failed' WHERE id = :id")->execute([':id'=>(int)$r['id']]);
        $fail++;
    }
}
echo "notifications_send sent={$ok} failed={$fail}\n";

