<?php
// Inserts a few sample rows so the UI can render without live API.
require __DIR__ . '/../../app/bootstrap.php';

use App\Database;
use App\Utils;

if (php_sapi_name() !== 'cli') { echo "Run from CLI\n"; exit(1); }

$pdo = Database::pdo();

$coins = [
    ['id'=>'bitcoin','symbol'=>'btc','name'=>'Bitcoin','rank'=>1,
     'image'=>'https://assets.coingecko.com/coins/images/1/small/bitcoin.png'],
    ['id'=>'ethereum','symbol'=>'eth','name'=>'Ethereum','rank'=>2,
     'image'=>'https://assets.coingecko.com/coins/images/279/small/ethereum.png'],
    ['id'=>'solana','symbol'=>'sol','name'=>'Solana','rank'=>5,
     'image'=>'https://assets.coingecko.com/coins/images/4128/small/solana.png'],
];

$upsertCoin = $pdo->prepare(
    "INSERT INTO coins (cg_id, symbol, name, slug, image_thumb, image_small, is_active, rank)
     VALUES (:cg_id, :symbol, :name, :slug, :image, :image, 1, :rank)
     ON DUPLICATE KEY UPDATE symbol=VALUES(symbol), name=VALUES(name), slug=VALUES(slug), image_thumb=VALUES(image_thumb), image_small=VALUES(image_small), rank=VALUES(rank)"
);

$getCoinId = $pdo->prepare("SELECT id FROM coins WHERE cg_id = :cg_id");
$insertSnap = $pdo->prepare(
    "INSERT IGNORE INTO coin_market_snapshots (coin_id, currency, price, market_cap, volume_24h, change_1h, change_24h, change_7d, change_30d, ath_drawdown, timestamp)
     VALUES (:coin_id, 'usd', :price, :mcap, :vol, :c1h, :c24h, :c7d, :c30d, :dd, :ts)"
);

$now = date('Y-m-d H:i:s');
foreach ($coins as $i => $c) {
    $upsertCoin->execute([
        ':cg_id'=>$c['id'], ':symbol'=>$c['symbol'], ':name'=>$c['name'], ':slug'=>Utils::slug($c['id']), ':image'=>$c['image'], ':rank'=>$c['rank']
    ]);
    $getCoinId->execute([':cg_id'=>$c['id']]);
    $coinId = (int)$getCoinId->fetchColumn();
    if (!$coinId) continue;
    $price = [68000, 3500, 150][$i];
    $mcap = [1340000000000, 420000000000, 67000000000][$i];
    $vol = [24000000000, 12000000000, 3800000000][$i];
    $c1h = [0.2, -0.1, 0.5][$i];
    $c24h = [1.5, -0.8, 3.2][$i];
    $c7d = [4.2, 2.8, 15.0][$i];
    $c30d = [12.0, 8.0, 35.5][$i];
    $dd = [-10.5, -18.2, -25.0][$i];
    $insertSnap->execute([':coin_id'=>$coinId, ':price'=>$price, ':mcap'=>$mcap, ':vol'=>$vol, ':c1h'=>$c1h, ':c24h'=>$c24h, ':c7d'=>$c7d, ':c30d'=>$c30d, ':dd'=>$dd, ':ts'=>$now]);
}

echo "Seeded sample data.\n";

