<?php
// Ping search engines about sitemap updates
require __DIR__ . '/../../app/bootstrap.php';
require_once __DIR__ . '/../lib/http.php';

use Scripts\Lib\Http;

if (php_sapi_name() !== 'cli') { echo "Run from CLI\n"; exit(1); }

$base = rtrim(App\Config::get('app.base_url',''), '/');
if (!$base) { echo "Set app.base_url first.\n"; exit(1); }
$sitemap = $base . '/sitemaps/sitemap-index.xml';

$targets = [
    'https://www.google.com/ping?sitemap=' . urlencode($sitemap),
    'https://www.bing.com/ping?sitemap=' . urlencode($sitemap),
];

foreach ($targets as $url) {
    try {
        Http::getJson($url, 10); // ignore body; use GET
        echo "Pinged: $url\n";
    } catch (\Throwable $e) {
        fwrite(STDERR, "Ping failed: $url — " . $e->getMessage() . "\n");
    }
}

