<?php
require __DIR__ . '/../../app/bootstrap.php';

use App\Database;

if (php_sapi_name() !== 'cli') { echo "Run from CLI\n"; exit(1); }

$pdo = Database::pdo();
$now = date('Y-m-d H:i:s');
$pdo->beginTransaction();
$stmt = $pdo->prepare("SELECT * FROM jobs WHERE status = 'queued' AND (not_before IS NULL OR not_before <= :now) ORDER BY id ASC LIMIT 1 FOR UPDATE");
$stmt->execute([':now'=>$now]);
$job = $stmt->fetch();
if (!$job) { $pdo->commit(); echo "No jobs.\n"; exit(0); }
$pdo->prepare("UPDATE jobs SET status='running', updated_at = NOW() WHERE id = :id")->execute([':id'=>(int)$job['id']]);
$pdo->commit();

$type = $job['type']; $payload = json_decode($job['payload_json'] ?? '[]', true) ?: [];
$ok = true; $err = '';
try {
    if ($type === 'sitemap_build') {
        // run builder
        require __DIR__ . '/../seo/sitemap_builder.php';
    } elseif ($type === 'notifications_send') {
        require __DIR__ . '/../ingest/notifications_send.php';
    } else {
        throw new \RuntimeException('Unknown job type: ' . $type);
    }
} catch (\Throwable $e) {
    $ok = false; $err = $e->getMessage();
}
$pdo->prepare("UPDATE jobs SET status = :st, last_error = :err, updated_at = NOW() WHERE id = :id")
    ->execute([':st'=>$ok?'done':'error', ':err'=>$err, ':id'=>(int)$job['id']]);
echo "Processed job #{$job['id']} ($type) => " . ($ok?'done':'error') . "\n";

